#!/usr/local/bin/perl
# Show details of one logged backup

require './virtual-server-lib.pl';
&ReadParse();
$in{'id'} =~ /^[0-9\.\-]+$/ || &error($text{'viewbackup_eid'});
$log = &get_backup_log($in{'id'});
$log || &error($text{'viewbackup_egone'});
$can = &can_backup_log($log);
$can || &error($text{'viewbackup_ecannot'});

&ui_print_header(undef, $text{'viewbackup_title'}, "");

# Extract backup plugin options if any
my %backup_plugin = &check_backup_pluging($log);

# Basic details
print &ui_table_start($text{'viewbackup_header'}, "width=100%", 4,
		      [ "nowrap" ]);

# Original scheduled backup
if ($log->{'sched'}) {
	($sched) = grep { $_->{'id'} eq $log->{'sched'} }
			&list_scheduled_backups();
	if ($sched) {
		@dests = &get_scheduled_backup_dests($sched);
		@nices = map { &nice_backup_url($_, 1, 1) } @dests;
		my $feature_link = &has_feature_link($log);
		print &ui_table_row($text{'viewbackup_sched'},
			&ui_link($feature_link."backup_form.cgi?sched=".
				 	&urlize($log->{'sched'}),
				 $log->{'desc'} || $nices[0]),
			3);
		}
	else {
		print &ui_table_row($text{'viewbackup_sched'},
				    &text('viewbackup_gone', $log->{'sched'}), 
			3);
		}
	}

# Destination
my ($proto, $user, $pass, $host, $path, $port) =
	&parse_backup_url($log->{'dest'});
my $nice = &nice_backup_url($log->{'dest'}, 1);
if ($proto == 0 && &foreign_available("filemin")) {
	if (&suffix_to_compression($path) >= 0) {
		$path =~ s/\/[^\/]+$//;
		}
	$nice = &ui_link("../filemin/index.cgi?path=".&urlize($path), $nice);
	}
print &ui_table_row($text{'viewbackup_dest'}, $nice, 3);

# Encryption key
print &ui_table_row($text{'viewbackup_enc'},
	!$log->{'key'} ? $text{'no'} :
	!defined(&get_backup_key) ?
		"<font color=#ff0000>$text{'viewbackup_nopro'}</font>" :
	!($key = &get_backup_key($log->{'key'})) ?
		"<font color=#ffaa00>".
		  &text('viewbackup_nokey', $log->{'key'})."</font>" :
		&text('viewbackup_key', "<i>$key->{'desc'}</i>"), 3);

# Backup plugin options if any
if ($backup_plugin{opts}) {
	my $opts  = $backup_plugin{opts};
	my %ptext = load_language($backup_plugin{name});
	for my $k (sort keys %$opts) {
		my $label = $ptext{"feat_${k}_opts"} // $k;
		my $val   = $ptext{"feat_${k}_opts_$opts->{$k}"} // $opts->{$k};
		next unless ($label && $val);
		print &ui_table_row($label, $val, 3);
		}
	}

# Domains included
@alldnames = split(/\s+/, $log->{'doms'});
@dnames = &backup_log_own_domains($log);
$msg = @alldnames > @dnames ? " , <b>".&text('viewbackup_extra',
					   @alldnames - @dnames)."</b>" : "";
print &ui_table_row($backup_plugin{indom} ?
		$text{'user_domain'} : $text{'viewbackup_doms'},
	join(" , ", @dnames).$msg || $text{'backuplog_nodoms'}, 3);

# Domains that failed, if any
@errdnames = &backup_log_own_domains($log, 1);
if (@errdnames) {
	print &ui_table_row($text{'viewbackup_errdoms'},
		   "<font color=#ff0000>".join(" , ", @errdnames)."</font>", 3);
	}

# Execution type
print &ui_table_row($text{'viewbackup_mode'},
	$text{'viewbackup_mode_'.$log->{'mode'}});

# By user
print &ui_table_row($text{'viewbackup_user'},
	$log->{'user'} || "<i>$text{'viewbackup_cmd'}</i>");

# Start and end times
print &ui_table_row($text{'viewbackup_start'},
	&make_date($log->{'start'}));
print &ui_table_row($text{'viewbackup_end'},
	&make_date($log->{'end'}));

# Final size
print &ui_table_row($text{'viewbackup_size'},
	&nice_size($log->{'size'}));

# Run time
print &ui_table_row($text{'viewbackup_time'},
	&nice_hour_mins_secs($log->{'end'} - $log->{'start'}));

if (!$backup_plugin{noincrement}) {
	# Differential?
	print &ui_table_row($text{'viewbackup_inc'},
		$log->{'increment'} == 1 ? $text{'viewbackup_inc1'} :
		$log->{'increment'} == 2 ? $text{'viewbackup_inc2'} :
					   $text{'viewbackup_inc0'});
	}
if (!$backup_plugin{noownrestore}) {
	# Can be restored by owners?
	print &ui_table_row($text{'viewbackup_ownrestore'},
		$log->{'ownrestore'} ? $text{'yes'} : $text{'no'});
	}

if (!$backup_plugin{nocompression}) {
	# Compression format?
	if (defined($log->{'compression'})) {
		print &ui_table_row($text{'viewbackup_compression'},
			$text{'backup_compression'.$log->{'compression'}});
		}
	}

if (!$backup_plugin{noseparate}) {
	# File format
	if (defined($log->{'separate'})) {
		print &ui_table_row($text{'viewbackup_separate'},
			$text{'backup_fmt'.$log->{'separate'}});
		}
	}

# Final result
print &ui_table_row($text{'viewbackup_ok'},
	$log->{'ok'} && !$log->{'errdoms'} ? $text{'viewbackup_success'} :
	$log->{'ok'} && $log->{'errdoms'} ?
		"<font color=#ffaa00>$text{'viewbackup_partial'}</font>" :
		"<font color=#ff0000>$text{'viewbackup_failure'}</font>");

print &ui_table_end();

if (@dnames == @alldnames) {
	# Full output
	print &ui_hidden_table_start($text{'viewbackup_output'}, "width=100%",
				     2, "output", $log->{'ok'} ? 0 : 1);
	print &ui_table_row(undef,
		$log->{'mode'} eq 'cgi' ? $log->{'output'} :
			"<pre>".&html_escape($log->{'output'})."</pre>", 2);
	print &ui_hidden_table_end();
	}

# Quick restore form
my $quick_restore = $backup_plugin{quick_restore};
if ($quick_restore && &can_restore_domain() &&
    ($log->{'ok'} || scalar(@alldnames) != scalar(@errdnames))) {
	print &ui_form_start("restore.cgi", "form-data");
	print &ui_hidden("log", $in{'id'});
	print &ui_hidden('features_all', 0);
	print &ui_hidden('feature', $backup_plugin{name});
	print &ui_hidden("origsrc", $log->{'dest'});
	print &ui_hidden("dom", $log->{'doms'});
	print &ui_hidden("return", $in{'return'});
	print &ui_form_end([ [ 'confirm', $text{'viewbackup_quick_restore'} ] ]);
	}

# Main form to submit
print &ui_form_start("restore_form.cgi");
print &ui_hidden("log", $in{'id'});
print &ui_hidden("return", $in{'return'});
print &ui_hidden("search", $in{'search'});
print &ui_hidden("plugin", $in{'plugin'});

# Can we restore?
my $restore = 0;
if ($log->{'ok'} || scalar(@alldnames) != scalar(@errdnames)) {
	$restore = 1;
	}

$restore = 0 if ($quick_restore);

if ($log->{'ok'} || $log->{'errdoms'}) {
	print &ui_form_end([
		$restore ? ( [ undef, $text{'viewbackup_restore'} ] ) : ( ),
		$can == 2 ? ( ) : ( [ 'delete', $text{'viewbackup_delete'} ] )
		]);
	}
else {
	print &ui_form_end();
	}

&ui_print_footer(&make_link('backuplog.cgi', 'search', 'plugin', 'return'),
		 $text{'backuplog_return'});
